;----------------------------------------------------------------------------
;    MODULE NAME:   RegressionTests-ExeCa.MMH
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.0  $
;          $Date:   07 Oct 2004 18:09:02  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/RegressionTests-ExeCa.mm.pvcs  $
;      COPYRIGHT:   (C)opyright Dennis Bareis, Australia, 2003
;                   All rights reserved.
;
;  Note that I had to pick a "EXE" that already existed for this demo...
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;--- Include common "regression test" logic and MAKEMSI support -------------
;----------------------------------------------------------------------------
#include "RegressionTests.MMH"


;--- During Build Create some files -----------------------------------------
#( ''
    #define BuildFile
    #define SRC_{$ID} <$MAKEMSI_OTHER_DIR>\{$ID}.TXT
    <$FileMake "<$SRC_{$ID}>">
        ;--- Generate contents ----------------------------------------------
        {$ShowUser}
    <$/FileMake>
#)
<$BuildFile ID="CostFinalize"    ShowUser=^ExeCa: Early in INSTALL: After 'CostFinalize' action<?NewLine>No files from MSI installed yet.<?NewLine>Install paused until program completes (notepad exited).^>
<$BuildFile ID="InstallFiles"    ShowUser=^ExeCa: After 'InstallFiles' action<?NewLine>Any MSI files are now installed.<?NewLine>Install paused until program completes (notepad exited).^>
<$BuildFile ID="InstallFinalize" ShowUser=^ExeCa: late in INSTALL: Just before 'InstallFinalize' action<?NewLine>Any MSI files are installed.<?NewLine>Install continues (does not wait for program to exit).^>


;--- Install some files -----------------------------------------------------
<$Files "<$SRC_CostFinalize>;<$SRC_InstallFiles>;<$SRC_InstallFinalize>" DESTDIR="INSTALLDIR">


;--- Pretty Early (install waits) -------------------------------------------
#(
   <$ExeCa
             EXE="[SystemFolder]notepad.exe"
            Args=^"<$SRC_CostFinalize>"^               ;;Files not yet installed so can only access previously installed files (source)
       CONDITION=^<$VBSCA_CONDITION_INSTALL_ONLY>^
             Seq="CostFinalize-"
            Type="AnyRc Immediate"                     ;;Ignore return code. Deferred (the default) custom actions can't be sequenced here!
   >
#)


;--- After files installed (install waits) ----------------------------------
#(
   <$ExeCa
             EXE="notepad.exe"                          ;;Its in the path so "[SystemFolder]" not required.
            Args=^"[INSTALLDIR]InstallFiles.TXT"^       ;;This is NOT the source file but the installed file
       CONDITION=^<$VBSCA_CONDITION_INSTALL_ONLY>^
            Type="AnyRc"
             Seq="InstallFiles-"
   >
#)


;--- Run program neart end of install, don't wait! --------------------------
#(
   <$ExeCa
             EXE="[SystemFolder]notepad.exe"
            Args=^"[INSTALLDIR]InstallFinalize"^       ;;This is NOT the source file but the installed file
       CONDITION=^<$VBSCA_CONDITION_INSTALL_ONLY>^
             Seq="<-InstallFinalize"
            Type="AnyRc Async"                         ;;Async = don't wait (also requires AnyRc!)
   >
#)

